(function($) {

  'use strict';

  //Global Object
  window.DALT = {};

  /**
   * Utility Methods
   */
  window.DALT.utility = {

    /**
     * Get the table id from the hidden fields available in the page.
     */
    get_table_id: function() {

      'use strict';

      let table_id = null;

      if ($('#temporary-table-id').length) {
        table_id = $('#temporary-table-id').val();
      } else {
        table_id = $('#update-id').val();
      }

      return parseInt(table_id, 10);

    },

    /**
     * Remove the bottom border on the cell of the main table (".daext-form-table")
     */
    remove_border_last_element_daext_form_table: function() {

      'use strict';

      $('table.daext-form-table tr > *').css('border-bottom-width', '1px');
      $('table.daext-form-table tr:visible:last > *').css('border-bottom-width', '0');

      },

    /*
     Initialize the handsontable table
     */
    initialize_handsontable: function() {

      'use strict';

      let order_by = null;
      let dalt_max_rows = null;
      let dalt_max_columns = null;
      let dalt_data = [];

      /*
       If the form is in edit mode retrieve the data of the table based on the table id, otherwise initialize an empty
       table.
       */
      if (parseInt($('#update-id').val()) > 0) {

        //prepare ajax request
        const data = {
          'action': 'dalt_retrieve_table_data',
          'security': DALT_PARAMETERS.nonce,
          'table_id': $('#update-id').val(),
        };

        //set ajax in synchronous mode
        jQuery.ajaxSetup({async: false});

        //send ajax request
        $.post(DALT_PARAMETERS.ajax_url, data, function(response_json) {

          'use strict';

          //initialize the table with the retrieved data
          const response_obj = JSON.parse(response_json);

          const data_content_obj = response_obj['data_content'];

          order_by = response_obj['order_by'];

          $.each(data_content_obj, function(index, value) {

            'use strict';

            dalt_data.push(value);

          });

          dalt_max_rows = parseInt($('#rows').val()) + 1;
          dalt_max_columns = parseInt($('#columns').val());

        });

        //set ajax in asynchronous mode
        jQuery.ajaxSetup({async: true});

      } else {

        //initialize an empty table
        dalt_data = [
          [
            'Label 1',
            'Label 2',
            'Label 3',
            'Label 4',
            'Label 5',
            'Label 6',
            'Label 7',
            'Label 8',
            'Label 9',
            'Label 10'],
          [0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
          [0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
          [0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
          [0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
          [0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
          [0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
          [0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
          [0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
          [0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
          [0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        ];

        dalt_max_rows = 11;
        dalt_max_columns = 10;

      }

      //Instantiate the handsontable table
      const dalt_container = document.getElementById('dalt-table');
      window.DALT.states.dalt_hot = new Handsontable(dalt_container,
          {

            afterSelection: function(row_index, column_index) {

              'use strict';

              window.DALT.utility.retrieve_cell_properties(row_index, column_index);

              },

            data: dalt_data,

            //set the new maximum number of rows and columns
            maxRows: dalt_max_rows,
            maxCols: dalt_max_columns,

            contextMenu: {
              items: {

                'insert_row_above': {
                  name: objectL10n.insert_row_above,
                  disabled: function() {

                    'use strict';

                    if (

                        //the first row is selected
                        window.DALT.states.dalt_hot.getSelected()[0][0] === 0 ||

                        //the maximum number of rows has been reached
                        window.DALT.states.dalt_hot.countRows() > 10000

                    ) {
                      return true;
                    }

                  },
                  callback: function(key, options) {

                    'use strict';

                    window.DALT.contextMenu.insert_row_above(options[0].start.row);

                    },
                },

                'insert_row_below': {
                  disabled: function() {

                    'use strict';

                    if (

                        //the maximum number of rows has been reached
                        window.DALT.states.dalt_hot.countRows() > 10000

                    ) {
                      return true;
                    }
                  },
                  name: objectL10n.insert_row_below,
                  callback: function(key, options) {

                    'use strict';

                    window.DALT.contextMenu.insert_row_below(options[0].start.row);

                  },
                },

                'sep_1': {name: '---------'},

                'insert_column_left': {
                  disabled: function() {

                    'use strict';

                    if (

                        //the maximum number of rows has been reached
                        window.DALT.states.dalt_hot.countCols() >= 40

                    ) {
                      return true;
                    }

                  },
                  name: objectL10n.insert_column_left,
                  callback: function(key, options) {

                    'use strict';

                    window.DALT.contextMenu.insert_column_left(options[0].start.col);

                  },
                },

                'insert_column_right': {
                  disabled: function() {

                    'use strict';

                    if (

                        //the maximum number of rows has been reached
                        window.DALT.states.dalt_hot.countCols() >= 40

                    ) {
                      return true;
                    }

                  },
                  name: objectL10n.insert_column_right,
                  callback: function(key, options) {

                    'use strict';

                    window.DALT.contextMenu.insert_column_right(options[0].start.col);

                  },
                },

                'sep_2': {name: '---------'},

                'remove_row': {
                  name: objectL10n.remove_row,
                  disabled: function() {

                    'use strict';

                    if (window.DALT.states.dalt_hot.getSelected()[0][0] === 0 ||
                        window.DALT.states.dalt_hot.countRows() === 2) {
                      return true;
                    }

                  },
                  callback: function(key, options) {

                    'use strict';

                    window.DALT.contextMenu.remove_row(options[0].start.row);

                  },
                },

                'remove_column': {
                  name: objectL10n.remove_column,
                  disabled: function() {

                    'use strict';

                    if (window.DALT.states.dalt_hot.countCols() === 1) {
                      return true;
                    }

                  },
                  callback: function(key, options) {

                    'use strict';

                    window.DALT.contextMenu.remove_column(options[0].start.col);

                  },
                },

                'sep_3': {name: '---------'},

                'copy': {
                  name: objectL10n.copy_data,
                },

                'cut': {
                  name: objectL10n.cut_data,
                },

                'paste': {
                  name: objectL10n.paste_data,
                  callback: function(key, options) {

                    'use strict';

                    $('.dialog-alert[data-id="dialog-keyboard-shortcut"]').dialog('open');

                  },
                },

                'sep_4': {name: '---------'},

                'copy_cell_properties': {
                  name: objectL10n.copy_cell_properties,
                  callback: function(key, options) {
                    if (window.DALT.utility.valid_cell_number(options[0])) {
                      window.DALT.contextMenu.copy_cell_properties(options[0]);
                    }
                  },
                },

                'cut_cell_properties': {
                  name: objectL10n.cut_cell_properties,
                  callback: function(key, options) {
                    if (window.DALT.utility.valid_cell_number(options[0])) {
                      window.DALT.contextMenu.cut_cell_properties(options[0]);
                    }
                  },
                },

                'paste_cell_properties': {
                  name: objectL10n.paste_cell_properties,
                  disabled: function() {

                    'use strict';

                    if(window.DALT.states.copiedCellProperties.data === null){
                      return true;
                    }

                  },
                  callback: function(key, options) {
                    window.DALT.contextMenu.paste_cell_properties(options[0]);
                  },
                },

                'sep_5': {name: '---------'},

                'reset_data': {
                  name: objectL10n.reset_data,
                  callback: function(key, options) {
                    if (window.DALT.utility.valid_cell_number(options[0])) {
                      window.DALT.contextMenu.reset_data(options[0]);
                    }
                  },
                },

                'reset_cell_properties': {
                  name: objectL10n.reset_cell_properties,
                  callback: function(key, options) {

                    'use strict';

                    if (window.DALT.utility.valid_cell_number(options[0])) {
                      window.DALT.contextMenu.reset_cell_properties(options[0]);
                      window.DALT.utility.retrieve_cell_properties(options[0].start.row, options[0].start.col);
                    }

                  },
                },

                'reset_data_and_cell_properties': {
                  name: objectL10n.reset_data_and_cell_properties,
                  callback: function(key, options) {

                    'use strict';

                    if (window.DALT.utility.valid_cell_number(options[0])) {
                      window.DALT.contextMenu.reset_data(options[0]);
                      window.DALT.contextMenu.reset_cell_properties(options[0]);
                      window.DALT.utility.retrieve_cell_properties(options[0].start.row, options[0].start.col);
                    }

                  },
                },

              },
            },

          });

      /*
      * Add the select element in the #order-by-* field from 1 to 5 based on the current number of columns.
      * Use the data that come from the ajax request to select the proper items
      */
      const number_of_columns = parseInt($('#columns').val());

      //generate the select element options
      let option_elements = '';
      for (let t = 1; t <= number_of_columns; t++) {
        option_elements += '<option value="' + t + '">' + objectL10n.column + ' ' + t + '</option>';
      }

      //add the select element option inside the select boxes
      for (let i = 1; i <= 5; i++) {
        $('#order-by-' + i).append(option_elements);
      }

      //if we are in edit mode select the proper element
      if (order_by !== undefined) {
        $.each(order_by, function(index, value) {

          'use strict';

          const selector = '#order-by-' + (parseInt(index, 10));
          window.DALT.utility.update_chosen_field(selector, value);

        });
      }

    },

    /*
     * Save the table. Used by the #save -> click event listener
     */
    save_table: function(reload_menu) {

      'use strict';

      //get form data
      const name = $('#name').val();
      const description = $('#description').val();
      const caption = $('#caption').val();
      const type = $('#type').val();
      const rows = $('#rows').val();
      const columns = $('#columns').val();

      //sorting
      const enable_sorting = $('#enable-sorting').val();
      const enable_manual_sorting = $('#enable-manual-sorting').val();
      const show_position = $('#show-position').val();
      const position_side = $('#position-side').val();
      const position_label = $('#position-label').val();
      const number_format = $('#number-format').val();
      const order_desc_asc_1 = $('#order-desc-asc-1').val();
      const order_by_1 = $('#order-by-1').val();
      const order_data_type_1 = $('#order-data-type-1').val();
      const order_date_format_1 = $('#order-date-format-1').val();
      const order_desc_asc_2 = $('#order-desc-asc-2').val();
      const order_by_2 = $('#order-by-2').val();
      const order_data_type_2 = $('#order-data-type-2').val();
      const order_date_format_2 = $('#order-date-format-2').val();
      const order_desc_asc_3 = $('#order-desc-asc-3').val();
      const order_by_3 = $('#order-by-3').val();
      const order_data_type_3 = $('#order-data-type-3').val();
      const order_date_format_3 = $('#order-date-format-3').val();
      const order_desc_asc_4 = $('#order-desc-asc-4').val();
      const order_by_4 = $('#order-by-4').val();
      const order_data_type_4 = $('#order-data-type-4').val();
      const order_date_format_4 = $('#order-date-format-4').val();
      const order_desc_asc_5 = $('#order-desc-asc-5').val();
      const order_by_5 = $('#order-by-5').val();
      const order_data_type_5 = $('#order-data-type-5').val();
      const order_date_format_5 = $('#order-date-format-5').val();

      //style
      const table_layout = $('#table-layout').val();
      const table_width = $('#table-width').val();
      const table_width_value = $('#table-width-value').val();
      const table_minimum_width = $('#table-minimum-width').val();
      const column_width = $('#column-width').val();
      const column_width_value = $('#column-width-value').val();
      const table_margin_top = $('#table-margin-top').val();
      const table_margin_bottom = $('#table-margin-bottom').val();
      const enable_container = $('#enable-container').val();
      const container_width = $('#container-width').val();
      const container_height = $('#container-height').val();
      const show_header = $('#show-header').val();
      const sticky_header = $('#sticky-header').val();
      const header_font_size = $('#header-font-size').val();
      const header_font_family = $('#header-font-family').val();
      const header_font_weight = $('#header-font-weight').val();
      const header_font_style = $('#header-font-style').val();
      const header_background_color = $('#header-background-color').val();
      const header_font_color = $('#header-font-color').val();
      const header_link_color = $('#header-link-color').val();
      const header_border_color = $('#header-border-color').val();
      const header_position_alignment = $('#header-position-alignment').val();
      const body_font_size = $('#body-font-size').val();
      const body_font_family = $('#body-font-family').val();
      const body_font_weight = $('#body-font-weight').val();
      const body_font_style = $('#body-font-style').val();
      const even_rows_background_color = $('#even-rows-background-color').val();
      const odd_rows_background_color = $('#odd-rows-background-color').val();
      const even_rows_font_color = $('#even-rows-font-color').val();
      const even_rows_link_color = $('#even-rows-link-color').val();
      const odd_rows_font_color = $('#odd-rows-font-color').val();
      const odd_rows_link_color = $('#odd-rows-link-color').val();
      const rows_border_color = $('#rows-border-color').val();
      const caption_show_caption = $('#caption-show-caption').val();
      const caption_caption_side = $('#caption-caption-side').val();
      const caption_text_align = $('#caption-text-align').val();
      const caption_font_size = $('#caption-font-size').val();
      const caption_font_family = $('#caption-font-family').val();
      const caption_font_weight = $('#caption-font-weight').val();
      const caption_font_style = $('#caption-font-style').val();
      const caption_font_color = $('#caption-font-color').val();

      //autocolors
      const autocolors_priority = $('#autocolors-priority').val();
      const autocolors_affected_rows_1 = $('#autocolors-affected-rows-1').val();
      const autocolors_rows_background_color_1 = $('#autocolors-rows-background-color-1').val();
      const autocolors_rows_font_color_1 = $('#autocolors-rows-font-color-1').val();
      const autocolors_affected_rows_2 = $('#autocolors-affected-rows-2').val();
      const autocolors_rows_background_color_2 = $('#autocolors-rows-background-color-2').val();
      const autocolors_rows_font_color_2 = $('#autocolors-rows-font-color-2').val();
      const autocolors_affected_rows_3 = $('#autocolors-affected-rows-3').val();
      const autocolors_rows_background_color_3 = $('#autocolors-rows-background-color-3').val();
      const autocolors_rows_font_color_3 = $('#autocolors-rows-font-color-3').val();
      const autocolors_affected_rows_4 = $('#autocolors-affected-rows-4').val();
      const autocolors_rows_background_color_4 = $('#autocolors-rows-background-color-4').val();
      const autocolors_rows_font_color_4 = $('#autocolors-rows-font-color-4').val();
      const autocolors_affected_rows_5 = $('#autocolors-affected-rows-5').val();
      const autocolors_rows_background_color_5 = $('#autocolors-rows-background-color-5').val();
      const autocolors_rows_font_color_5 = $('#autocolors-rows-font-color-5').val();
      const autocolors_affected_columns_1 = $('#autocolors-affected-columns-1').val();
      const autocolors_columns_background_color_1 = $('#autocolors-columns-background-color-1').val();
      const autocolors_columns_font_color_1 = $('#autocolors-columns-font-color-1').val();
      const autocolors_affected_columns_2 = $('#autocolors-affected-columns-2').val();
      const autocolors_columns_background_color_2 = $('#autocolors-columns-background-color-2').val();
      const autocolors_columns_font_color_2 = $('#autocolors-columns-font-color-2').val();
      const autocolors_affected_columns_3 = $('#autocolors-affected-columns-3').val();
      const autocolors_columns_background_color_3 = $('#autocolors-columns-background-color-3').val();
      const autocolors_columns_font_color_3 = $('#autocolors-columns-font-color-3').val();
      const autocolors_affected_columns_4 = $('#autocolors-affected-columns-4').val();
      const autocolors_columns_background_color_4 = $('#autocolors-columns-background-color-4').val();
      const autocolors_columns_font_color_4 = $('#autocolors-columns-font-color-4').val();
      const autocolors_affected_columns_5 = $('#autocolors-affected-columns-5').val();
      const autocolors_columns_background_color_5 = $('#autocolors-columns-background-color-5').val();
      const autocolors_columns_font_color_5 = $('#autocolors-columns-font-color-5').val();

      //autoalignment
      const autoalignment_priority = $('#autoalignment-priority').val();
      const autoalignment_affected_rows_left = $('#autoalignment-affected-rows-left').val();
      const autoalignment_affected_rows_center = $('#autoalignment-affected-rows-center').val();
      const autoalignment_affected_rows_right = $('#autoalignment-affected-rows-right').val();
      const autoalignment_affected_columns_left = $('#autoalignment-affected-columns-left').val();
      const autoalignment_affected_columns_center = $('#autoalignment-affected-columns-center').val();
      const autoalignment_affected_columns_right = $('#autoalignment-affected-columns-right').val();

      //responsive
      const tablet_breakpoint = $('#tablet-breakpoint').val();
      const hide_tablet_list = $('#hide-tablet-list').val();
      const tablet_header_font_size = $('#tablet-header-font-size').val();
      const tablet_body_font_size = $('#tablet-body-font-size').val();
      const tablet_caption_font_size = $('#tablet-caption-font-size').val();
      const tablet_hide_images = $('#tablet-hide-images').val();
      const phone_breakpoint = $('#phone-breakpoint').val();
      const hide_phone_list = $('#hide-phone-list').val();
      const phone_header_font_size = $('#phone-header-font-size').val();
      const phone_body_font_size = $('#phone-body-font-size').val();
      const phone_caption_font_size = $('#phone-caption-font-size').val();
      const phone_hide_images = $('#phone-hide-images').val();

      //advanced
      const enable_cell_properties = $('#enable-cell-properties').val();
      const formula_average_decimals = $('#formula-average-decimals').val();
      const formula_average_round = $('#formula-average-round').val();

      //save the table data available as a JavaScript value in a JSON string
      const table_data = JSON.stringify({data: window.DALT.states.dalt_hot.getData()});

      //prepare ajax request
      const data = {

        'action': 'dalt_save_data',
        'security': DALT_PARAMETERS.nonce,
        'table_id': window.DALT.utility.get_table_id(),

        //general
        'name': name,
        'description': description,
        'caption': caption,
        'rows': rows,
        'columns': columns,
        'table_data': table_data,

        //sorting
        'enable_sorting': enable_sorting,
        'enable_manual_sorting': enable_manual_sorting,
        'show_position': show_position,
        'position_side': position_side,
        'position_label': position_label,
        'number_format': number_format,
        'order_desc_asc_1': order_desc_asc_1,
        'order_by_1': order_by_1,
        'order_data_type_1': order_data_type_1,
        'order_date_format_1': order_date_format_1,
        'order_desc_asc_2': order_desc_asc_2,
        'order_by_2': order_by_2,
        'order_data_type_2': order_data_type_2,
        'order_date_format_2': order_date_format_2,
        'order_desc_asc_3': order_desc_asc_3,
        'order_by_3': order_by_3,
        'order_data_type_3': order_data_type_3,
        'order_date_format_3': order_date_format_3,
        'order_desc_asc_4': order_desc_asc_4,
        'order_by_4': order_by_4,
        'order_data_type_4': order_data_type_4,
        'order_date_format_4': order_date_format_4,
        'order_desc_asc_5': order_desc_asc_5,
        'order_by_5': order_by_5,
        'order_data_type_5': order_data_type_5,
        'order_date_format_5': order_date_format_5,

        //style
        'table_layout': table_layout,
        'table_width': table_width,
        'table_width_value': table_width_value,
        'table_minimum_width': table_minimum_width,
        'column_width': column_width,
        'column_width_value': column_width_value,
        'table_margin_top': table_margin_top,
        'table_margin_bottom': table_margin_bottom,
        'enable_container': enable_container,
        'container_width': container_width,
        'container_height': container_height,
        'show_header': show_header,
        'sticky_header': sticky_header,
        'header_font_size': header_font_size,
        'header_font_family': header_font_family,
        'header_font_weight': header_font_weight,
        'header_font_style': header_font_style,
        'header_background_color': header_background_color,
        'header_font_color': header_font_color,
        'header_link_color': header_link_color,
        'header_border_color': header_border_color,
        'header_position_alignment': header_position_alignment,
        'body_font_size': body_font_size,
        'body_font_family': body_font_family,
        'body_font_weight': body_font_weight,
        'body_font_style': body_font_style,
        'even_rows_background_color': even_rows_background_color,
        'odd_rows_background_color': odd_rows_background_color,
        'even_rows_font_color': even_rows_font_color,
        'even_rows_link_color': even_rows_link_color,
        'odd_rows_font_color': odd_rows_font_color,
        'odd_rows_link_color': odd_rows_link_color,
        'rows_border_color': rows_border_color,
        'caption_show_caption': caption_show_caption,
        'caption_caption_side': caption_caption_side,
        'caption_text_align': caption_text_align,
        'caption_font_size': caption_font_size,
        'caption_font_family': caption_font_family,
        'caption_font_weight': caption_font_weight,
        'caption_font_style': caption_font_style,
        'caption_font_color': caption_font_color,
        
        //autocolors
        'autocolors_priority': autocolors_priority,
        'autocolors_affected_rows_1': autocolors_affected_rows_1,
        'autocolors_rows_background_color_1': autocolors_rows_background_color_1,
        'autocolors_rows_font_color_1': autocolors_rows_font_color_1,
        'autocolors_affected_rows_2': autocolors_affected_rows_2,
        'autocolors_rows_background_color_2': autocolors_rows_background_color_2,
        'autocolors_rows_font_color_2': autocolors_rows_font_color_2,
        'autocolors_affected_rows_3': autocolors_affected_rows_3,
        'autocolors_rows_background_color_3': autocolors_rows_background_color_3,
        'autocolors_rows_font_color_3': autocolors_rows_font_color_3,
        'autocolors_affected_rows_4': autocolors_affected_rows_4,
        'autocolors_rows_background_color_4': autocolors_rows_background_color_4,
        'autocolors_rows_font_color_4': autocolors_rows_font_color_4,
        'autocolors_affected_rows_5': autocolors_affected_rows_5,
        'autocolors_rows_background_color_5': autocolors_rows_background_color_5,
        'autocolors_rows_font_color_5': autocolors_rows_font_color_5,
        'autocolors_affected_columns_1': autocolors_affected_columns_1,
        'autocolors_columns_background_color_1': autocolors_columns_background_color_1,
        'autocolors_columns_font_color_1': autocolors_columns_font_color_1,
        'autocolors_affected_columns_2': autocolors_affected_columns_2,
        'autocolors_columns_background_color_2': autocolors_columns_background_color_2,
        'autocolors_columns_font_color_2': autocolors_columns_font_color_2,
        'autocolors_affected_columns_3': autocolors_affected_columns_3,
        'autocolors_columns_background_color_3': autocolors_columns_background_color_3,
        'autocolors_columns_font_color_3': autocolors_columns_font_color_3,
        'autocolors_affected_columns_4': autocolors_affected_columns_4,
        'autocolors_columns_background_color_4': autocolors_columns_background_color_4,
        'autocolors_columns_font_color_4': autocolors_columns_font_color_4,
        'autocolors_affected_columns_5': autocolors_affected_columns_5,
        'autocolors_columns_background_color_5': autocolors_columns_background_color_5,
        'autocolors_columns_font_color_5': autocolors_columns_font_color_5,

        //autoalignment
        'autoalignment_priority': autoalignment_priority,
        'autoalignment_affected_rows_left': autoalignment_affected_rows_left,
        'autoalignment_affected_rows_center': autoalignment_affected_rows_center,
        'autoalignment_affected_rows_right': autoalignment_affected_rows_right,
        'autoalignment_affected_columns_left': autoalignment_affected_columns_left,
        'autoalignment_affected_columns_center': autoalignment_affected_columns_center,
        'autoalignment_affected_columns_right': autoalignment_affected_columns_right,

        //responsive
        'tablet_breakpoint': tablet_breakpoint,
        'hide_tablet_list': hide_tablet_list,
        'tablet_header_font_size': tablet_header_font_size,
        'tablet_body_font_size': tablet_body_font_size,
        'tablet_caption_font_size': tablet_caption_font_size,
        'tablet_hide_images': tablet_hide_images,
        'phone_breakpoint': phone_breakpoint,
        'hide_phone_list': hide_phone_list,
        'phone_header_font_size': phone_header_font_size,
        'phone_body_font_size': phone_body_font_size,
        'phone_caption_font_size': phone_caption_font_size,
        'phone_hide_images': phone_hide_images,

        //advanced
        'enable_cell_properties': enable_cell_properties,
        'formula_average_decimals': formula_average_decimals,
        'formula_average_round': formula_average_round,
      };

      const validation_result = window.DALT.utility.table_is_valid(data);
      if (validation_result === true) {

        //set ajax in synchronous mode
        jQuery.ajaxSetup({async: false});

        //send ajax request
        $.post(DALT_PARAMETERS.ajax_url, data, function(data) {

          'use strict';

          if (reload_menu === true) {

            //reload the dashboard menu
            window.location.replace(DALT_PARAMETERS.admin_url + 'admin.php?page=dalt-tables');

          }

        });

        //set ajax in asynchronous mode
        jQuery.ajaxSetup({async: true});

        return true;

      } else {

        return validation_result;

      }

    },

    /**
     * The reason why this function is useful is that using specific keyword shortcut while editing the Handsontable
     * might be confusing or generates problems.
     *
     * The following keyboard shortcuts are disabled:
     *
     * - CTRL+M (merge/unmerge selected cells)
     * - CTRL+Enter (fill all selected cells with edited cell's value)
     * - CTRL+Z (undo)
     * - CTRL+Y (undo)
     *
     * The following keyboard shortcuts are enabled:
     *
     * - CTRL+C (copy cell's content)
     * - CTRL+V (paste cell's content)
     * - CTRL+X (cut cell's content)
     *
     * Keyboard shortcuts in Handsontable: https://handsontable.com/docs/7.0.2/tutorial-keyboard-navigation.html
     */
    disable_specific_keyboard_shortcuts: function() {

      'use strict';

      $('#dalt-table-td').keydown(function(e) {

        'use strict';

        if ( ((e.ctrlKey || e.metaKey) && e.keyCode === 77) || //CTRL+M
            ((e.ctrlKey || e.metaKey) && e.keyCode === 13) || //CTRL+Enter
            ((e.ctrlKey || e.metaKey) && e.keyCode === 90) || //CTRL+Z
            ((e.ctrlKey || e.metaKey) && e.keyCode === 89) //CTRL+Y
        ) {
          e.preventDefault();
          $('.dialog-alert[data-id="specific-shortcut-disabled"]').dialog('open');
          return false;
        }

      });

    },

    /*
     Verifies if the data of the table are valid
     */
    table_is_valid: function(data) {

      'use strict';

      //init variables
      let fields_with_errors_a = [];

      //define regex patterns ----------------------------------------------------------------------------------------
      const digits_regex = /^\s*\d+\s*$/;
      const font_family_regex = /^([A-Za-z0-9-\'", ]*)$/;
      const list_of_comma_separated_numbers = /^(\s*(\d+\s*,\s*)+\d+\s*|\s*\d+\s*)$/;
      const hex_rgb_regex = /^#(?:[0-9a-fA-F]{3}){1,2}$/;

      //validate data ------------------------------------------------------------------------------------------------

      //Basic Info
      if (data.name.trim().length < 1 || data.name.trim().length > 255) {fields_with_errors_a.push(objectL10n.name);}
      if (data.description.trim().length < 1 || data.description.trim().length > 255) {
        fields_with_errors_a.push(objectL10n.description);
      }
      if (data.caption.trim().length > 2000) {fields_with_errors_a.push(objectL10n.caption);}
      if (!data.rows.match(digits_regex) || parseInt(data.rows, 10) < 1 || parseInt(data.rows, 10) >
          10000) {fields_with_errors_a.push(objectL10n.rows);}
      if (!data.columns.match(digits_regex) || parseInt(data.columns, 10) < 1 || parseInt(data.columns, 10) >
          40) {fields_with_errors_a.push(objectL10n.columns);}

      //Sorting Options
      if (data.position_label.trim().length < 1 || data.position_label.trim().length > 255) {
        fields_with_errors_a.push(objectL10n.position_label);
      }

      //Style Options
      if (!data.table_width_value.match(digits_regex) || parseInt(data.table_width_value, 10) < 1 ||
          parseInt(data.table_width_value, 10) > 999999) {fields_with_errors_a.push(objectL10n.table_width_value);}
      if (!data.table_minimum_width.match(digits_regex) || parseInt(data.table_minimum_width, 10) < 0 ||
          parseInt(data.table_minimum_width, 10) > 999999) {fields_with_errors_a.push(objectL10n.table_minimum_width);}
      if ((!data.column_width_value.match(list_of_comma_separated_numbers) && data.column_width_value.trim().length >
          0) || data.column_width_value.trim().length > 2000) {
        fields_with_errors_a.push(objectL10n.column_width_value);
      }
      if (!data.container_width.match(digits_regex) || parseInt(data.container_width, 10) < 0 ||
          parseInt(data.container_width, 10) > 999999) {fields_with_errors_a.push(objectL10n.container_width);}
      if (!data.container_height.match(digits_regex) || parseInt(data.container_height, 10) < 0 ||
          parseInt(data.container_height, 10) > 999999) {fields_with_errors_a.push(objectL10n.container_height);}
      if (!data.table_margin_top.match(digits_regex) || parseInt(data.table_margin_top, 10) < 0 ||
          parseInt(data.table_margin_top, 10) > 999999) {fields_with_errors_a.push(objectL10n.table_margin_top);}
      if (!data.table_margin_bottom.match(digits_regex) || parseInt(data.table_margin_bottom, 10) < 0 ||
          parseInt(data.table_margin_bottom, 10) > 999999) {fields_with_errors_a.push(objectL10n.table_margin_bottom);}
      if (!data.header_font_size.match(digits_regex) || parseInt(data.header_font_size, 10) < 0 ||
          parseInt(data.header_font_size, 10) > 999999) {fields_with_errors_a.push(objectL10n.header_font_size);}
      if (!data.header_font_family.match(font_family_regex) || data.header_font_family.trim().length < 1 ||
          data.header_font_family.trim().length > 255) {fields_with_errors_a.push(objectL10n.header_font_family);}
      if (!data.header_background_color.match(hex_rgb_regex)) {
        fields_with_errors_a.push(objectL10n.header_background_color);
      }
      if (!data.header_font_color.match(hex_rgb_regex)) {fields_with_errors_a.push(objectL10n.header_font_color);}
      if (!data.header_link_color.match(hex_rgb_regex)) {fields_with_errors_a.push(objectL10n.header_link_color);}
      if (!data.header_border_color.match(hex_rgb_regex)) {fields_with_errors_a.push(objectL10n.header_border_color);}
      if (!data.body_font_size.match(digits_regex) || parseInt(data.body_font_size, 10) < 0 ||
          parseInt(data.body_font_size, 10) > 999999) {fields_with_errors_a.push(objectL10n.body_font_size);}
      if (!data.body_font_family.match(font_family_regex)) {fields_with_errors_a.push(objectL10n.body_font_family);}
      if (!data.even_rows_background_color.match(hex_rgb_regex)) {
        fields_with_errors_a.push(objectL10n.even_rows_background_color);
      }
      if (!data.odd_rows_background_color.match(hex_rgb_regex)) {
        fields_with_errors_a.push(objectL10n.odd_rows_background_color);
      }
      if (!data.even_rows_font_color.match(hex_rgb_regex)) {fields_with_errors_a.push(objectL10n.even_rows_font_color);}
      if (!data.odd_rows_font_color.match(hex_rgb_regex)) {fields_with_errors_a.push(objectL10n.odd_rows_font_color);}
      if (!data.even_rows_link_color.match(hex_rgb_regex)) {fields_with_errors_a.push(objectL10n.even_rows_link_color);}
      if (!data.odd_rows_link_color.match(hex_rgb_regex)) {fields_with_errors_a.push(objectL10n.odd_rows_link_color);}
      if (!data.rows_border_color.match(hex_rgb_regex)) {fields_with_errors_a.push(objectL10n.rows_border_color);}
      if (!data.caption_font_size.match(digits_regex) || parseInt(data.caption_font_size, 10) < 0 ||
          parseInt(data.caption_font_size, 10) > 65535) {fields_with_errors_a.push(objectL10n.caption_font_size);}
      if (!data.caption_font_family.match(font_family_regex) || data.caption_font_family.trim().length < 1 ||
          data.caption_font_family.trim().length > 255) {fields_with_errors_a.push(objectL10n.caption_font_family);}
      if (!data.caption_font_color.match(hex_rgb_regex)) {fields_with_errors_a.push(objectL10n.caption_font_color);}
      
      //Autocolors Options
      if ((!data.autocolors_affected_rows_1.match(list_of_comma_separated_numbers) &&
          data.autocolors_affected_rows_1.trim().length > 0) || data.autocolors_affected_rows_1.trim().length >
          2000) {fields_with_errors_a.push(objectL10n.autocolors_affected_rows_1);}
      if (!data.autocolors_rows_background_color_1.match(hex_rgb_regex)) {
        fields_with_errors_a.push(objectL10n.autocolors_rows_background_color_1);
      }
      if (!data.autocolors_rows_font_color_1.match(hex_rgb_regex)) {
        fields_with_errors_a.push(objectL10n.autocolors_rows_font_color_1);
      }
      if ((!data.autocolors_affected_rows_2.match(list_of_comma_separated_numbers) &&
          data.autocolors_affected_rows_2.trim().length > 0) || data.autocolors_affected_rows_2.trim().length >
          2000) {fields_with_errors_a.push(objectL10n.autocolors_affected_rows_2);}
      if (!data.autocolors_rows_background_color_2.match(hex_rgb_regex)) {
        fields_with_errors_a.push(objectL10n.autocolors_rows_background_color_2);
      }
      if (!data.autocolors_rows_font_color_2.match(hex_rgb_regex)) {
        fields_with_errors_a.push(objectL10n.autocolors_rows_font_color_2);
      }
      if ((!data.autocolors_affected_rows_3.match(list_of_comma_separated_numbers) &&
          data.autocolors_affected_rows_3.trim().length > 0) || data.autocolors_affected_rows_3.trim().length >
          2000) {fields_with_errors_a.push(objectL10n.autocolors_affected_rows_3);}
      if (!data.autocolors_rows_background_color_3.match(hex_rgb_regex)) {
        fields_with_errors_a.push(objectL10n.autocolors_rows_background_color_3);
      }
      if (!data.autocolors_rows_font_color_3.match(hex_rgb_regex)) {
        fields_with_errors_a.push(objectL10n.autocolors_rows_font_color_3);
      }
      if ((!data.autocolors_affected_rows_4.match(list_of_comma_separated_numbers) &&
          data.autocolors_affected_rows_4.trim().length > 0) || data.autocolors_affected_rows_4.trim().length >
          2000) {fields_with_errors_a.push(objectL10n.autocolors_affected_rows_4);}
      if (!data.autocolors_rows_background_color_4.match(hex_rgb_regex)) {
        fields_with_errors_a.push(objectL10n.autocolors_rows_background_color_4);
      }
      if (!data.autocolors_rows_font_color_4.match(hex_rgb_regex)) {
        fields_with_errors_a.push(objectL10n.autocolors_rows_font_color_4);
      }
      if ((!data.autocolors_affected_rows_5.match(list_of_comma_separated_numbers) &&
          data.autocolors_affected_rows_5.trim().length > 0) || data.autocolors_affected_rows_5.trim().length >
          2000) {fields_with_errors_a.push(objectL10n.autocolors_affected_rows_5);}
      if (!data.autocolors_rows_background_color_5.match(hex_rgb_regex)) {
        fields_with_errors_a.push(objectL10n.autocolors_rows_background_color_5);
      }
      if (!data.autocolors_rows_font_color_5.match(hex_rgb_regex)) {
        fields_with_errors_a.push(objectL10n.autocolors_rows_font_color_5);
      }
      if ((!data.autocolors_affected_columns_1.match(list_of_comma_separated_numbers) &&
          data.autocolors_affected_columns_1.trim().length > 0) || data.autocolors_affected_columns_1.trim().length >
          110) {fields_with_errors_a.push(objectL10n.autocolors_affected_columns_1);}
      if (!data.autocolors_columns_background_color_1.match(hex_rgb_regex)) {
        fields_with_errors_a.push(objectL10n.autocolors_columns_background_color_1);
      }
      if (!data.autocolors_columns_font_color_1.match(hex_rgb_regex)) {
        fields_with_errors_a.push(objectL10n.autocolors_columns_font_color_1);
      }
      if ((!data.autocolors_affected_columns_2.match(list_of_comma_separated_numbers) &&
          data.autocolors_affected_columns_2.trim().length > 0) || data.autocolors_affected_columns_2.trim().length >
          110) {fields_with_errors_a.push(objectL10n.autocolors_affected_columns_2);}
      if (!data.autocolors_columns_background_color_2.match(hex_rgb_regex)) {
        fields_with_errors_a.push(objectL10n.autocolors_columns_background_color_2);
      }
      if (!data.autocolors_columns_font_color_2.match(hex_rgb_regex)) {
        fields_with_errors_a.push(objectL10n.autocolors_columns_font_color_2);
      }
      if ((!data.autocolors_affected_columns_3.match(list_of_comma_separated_numbers) &&
          data.autocolors_affected_columns_3.trim().length > 0) || data.autocolors_affected_columns_3.trim().length >
          110) {fields_with_errors_a.push(objectL10n.autocolors_affected_columns_3);}
      if (!data.autocolors_columns_background_color_3.match(hex_rgb_regex)) {
        fields_with_errors_a.push(objectL10n.autocolors_columns_background_color_3);
      }
      if (!data.autocolors_columns_font_color_3.match(hex_rgb_regex)) {
        fields_with_errors_a.push(objectL10n.autocolors_columns_font_color_3);
      }
      if ((!data.autocolors_affected_columns_4.match(list_of_comma_separated_numbers) &&
          data.autocolors_affected_columns_4.trim().length > 0) || data.autocolors_affected_columns_4.trim().length >
          110) {fields_with_errors_a.push(objectL10n.autocolors_affected_columns_4);}
      if (!data.autocolors_columns_background_color_4.match(hex_rgb_regex)) {
        fields_with_errors_a.push(objectL10n.autocolors_columns_background_color_4);
      }
      if (!data.autocolors_columns_font_color_4.match(hex_rgb_regex)) {
        fields_with_errors_a.push(objectL10n.autocolors_columns_font_color_4);
      }
      if ((!data.autocolors_affected_columns_5.match(list_of_comma_separated_numbers) &&
          data.autocolors_affected_columns_5.trim().length > 0) || data.autocolors_affected_columns_5.trim().length >
          110) {fields_with_errors_a.push(objectL10n.autocolors_affected_columns_5);}
      if (!data.autocolors_columns_background_color_5.match(hex_rgb_regex)) {
        fields_with_errors_a.push(objectL10n.autocolors_columns_background_color_5);
      }
      if (!data.autocolors_columns_font_color_5.match(hex_rgb_regex)) {
        fields_with_errors_a.push(objectL10n.autocolors_columns_font_color_5);
      }

      //Autoalignment Options
      if ((!data.autoalignment_affected_rows_left.match(list_of_comma_separated_numbers) &&
          data.autoalignment_affected_rows_left.trim().length > 0) ||
          data.autoalignment_affected_rows_left.trim().length > 2000) {
        fields_with_errors_a.push(objectL10n.autoalignment_affected_rows_left);
      }
      if ((!data.autoalignment_affected_rows_center.match(list_of_comma_separated_numbers) &&
          data.autoalignment_affected_rows_center.trim().length > 0) ||
          data.autoalignment_affected_rows_center.trim().length > 2000) {
        fields_with_errors_a.push(objectL10n.autoalignment_affected_rows_center);
      }
      if ((!data.autoalignment_affected_rows_right.match(list_of_comma_separated_numbers) &&
          data.autoalignment_affected_rows_right.trim().length > 0) ||
          data.autoalignment_affected_rows_right.trim().length > 2000) {
        fields_with_errors_a.push(objectL10n.autoalignment_affected_rows_right);
      }
      if ((!data.autoalignment_affected_columns_left.match(list_of_comma_separated_numbers) &&
          data.autoalignment_affected_columns_left.trim().length > 0) ||
          data.autoalignment_affected_columns_left.trim().length > 110) {
        fields_with_errors_a.push(objectL10n.autoalignment_affected_columns_left);
      }
      if ((!data.autoalignment_affected_columns_center.match(list_of_comma_separated_numbers) &&
          data.autoalignment_affected_columns_center.trim().length > 0) ||
          data.autoalignment_affected_columns_center.trim().length > 110) {
        fields_with_errors_a.push(objectL10n.autoalignment_affected_columns_center);
      }
      if ((!data.autoalignment_affected_columns_right.match(list_of_comma_separated_numbers) &&
          data.autoalignment_affected_columns_right.trim().length > 0) ||
          data.autoalignment_affected_columns_right.trim().length > 110) {
        fields_with_errors_a.push(objectL10n.autoalignment_affected_columns_right);
      }

      //Responsive Options
      if (!data.tablet_breakpoint.match(digits_regex) || parseInt(data.tablet_breakpoint, 10) < 0 ||
          parseInt(data.tablet_breakpoint, 10) > 999999) {fields_with_errors_a.push(objectL10n.tablet_breakpoint);}
      if (!data.hide_tablet_list.match(list_of_comma_separated_numbers) && data.hide_tablet_list.trim().length >
          0) {fields_with_errors_a.push(objectL10n.hide_tablet_list);}
      if (!data.tablet_header_font_size.match(digits_regex) || parseInt(data.tablet_header_font_size, 10) < 0 ||
          parseInt(data.tablet_header_font_size, 10) > 999999) {
        fields_with_errors_a.push(objectL10n.tablet_header_font_size);
      }
      if (!data.tablet_body_font_size.match(digits_regex) || parseInt(data.tablet_body_font_size, 10) < 0 ||
          parseInt(data.tablet_body_font_size, 10) > 999999) {
        fields_with_errors_a.push(objectL10n.tablet_body_font_size);
      }
      if (!data.tablet_caption_font_size.match(digits_regex) || parseInt(data.tablet_caption_font_size, 10) < 0 ||
          parseInt(data.tablet_caption_font_size, 10) > 999999) {
        fields_with_errors_a.push(objectL10n.tablet_caption_font_size);
      }
      if (!data.phone_breakpoint.match(digits_regex) || parseInt(data.phone_breakpoint, 10) < 0 ||
          parseInt(data.phone_breakpoint, 10) > 999999) {fields_with_errors_a.push(objectL10n.phone_breakpoint);}
      if (!data.hide_phone_list.match(list_of_comma_separated_numbers) && data.hide_phone_list.trim().length >
          0) {fields_with_errors_a.push(objectL10n.hide_phone_list);}
      if (!data.phone_header_font_size.match(digits_regex) || parseInt(data.phone_header_font_size, 10) < 0 ||
          parseInt(data.phone_header_font_size, 10) > 999999) {
        fields_with_errors_a.push(objectL10n.phone_header_font_size);
      }
      if (!data.phone_body_font_size.match(digits_regex) || parseInt(data.phone_body_font_size, 10) < 0 ||
          parseInt(data.phone_body_font_size, 10) > 999999) {
        fields_with_errors_a.push(objectL10n.phone_body_font_size);
      }
      if (!data.phone_caption_font_size.match(digits_regex) || parseInt(data.phone_caption_font_size, 10) < 0 ||
          parseInt(data.phone_caption_font_size, 10) > 999999) {
        fields_with_errors_a.push(objectL10n.phone_caption_font_size);
      }

      //Advanced Options
      if (!data.formula_average_decimals.match(digits_regex) || parseInt(data.formula_average_decimals, 10) < 0 ||
          parseInt(data.formula_average_decimals, 10) > 999999) {
        fields_with_errors_a.push(objectL10n.formula_average_decimals);
      }

      if (fields_with_errors_a.length > 0) {

        return fields_with_errors_a;

      } else {

        return true;

      }

    },

    /*
     * Update the number of rows on the handsontable and on the "data" db table
     */
    update_rows: function() {

      'use strict';

      /**
       * Reset the spreadsheet clipboard because after performing this method certain references to cell properties
       * might be lost.
       */
      window.DALT.states.synthetic_clipboard = null;

      //change the number of rows
      const current_number_of_rows = window.DALT.states.dalt_hot.countRows() - 1;
      if ($('#rows').val() < 1) {$('#rows').val(1);}
      let new_number_of_rows = parseInt($('#rows').val(), 10);

      //Do not allow to enter more rows than 10000 rows
      if (new_number_of_rows > 10000) {
        new_number_of_rows = 10000;
        $('#rows').val(10000);
      }

      if (new_number_of_rows > current_number_of_rows) {

        //set the new maximum number of rows
        window.DALT.states.dalt_hot.updateSettings({
          maxRows: (new_number_of_rows + 1),
        });

        let cells_to_add = [];
        const row_difference = new_number_of_rows - current_number_of_rows;
        const count_rows_result = window.DALT.states.dalt_hot.countRows();
        const count_cols_result = window.DALT.states.dalt_hot.countCols();

        for (let i = 1; i <= row_difference; i++) {

          //initialize with 0 all the cells of the new row
          for (let t = 1; t <= count_cols_result; t++) {
            cells_to_add.push([count_rows_result + i - 1, (t - 1), 0]);
          }

        }

        //create the new rows
        window.DALT.states.dalt_hot.alter('insert_row', null, row_difference);

        //use the setDataAtCell() method one single time with a two dimensional array to avoid performance issues
        window.DALT.states.dalt_hot.setDataAtCell(cells_to_add);

      } else if (new_number_of_rows < current_number_of_rows) {

        const row_difference = current_number_of_rows - new_number_of_rows;

        window.DALT.states.dalt_hot.alter('remove_row', null, row_difference);

        //set the new maximum number of rows
        window.DALT.states.dalt_hot.updateSettings({
          maxRows: (new_number_of_rows + 1),
        });

      }

      //create or remove the new rows in the 'data' db table with an asynchronous ajax request -----------------------
      if (new_number_of_rows != current_number_of_rows) {

        const data = {
          'action': 'dalt_add_remove_rows',
          'security': DALT_PARAMETERS.nonce,
          'table_id': window.DALT.utility.get_table_id(),
          'current_number_of_rows': current_number_of_rows,
          'new_number_of_rows': new_number_of_rows,
          'current_number_of_columns': window.DALT.states.dalt_hot.countCols(),
        };

        //set ajax in synchronous mode
        jQuery.ajaxSetup({async: false});

        //send ajax request
        $.post(DALT_PARAMETERS.ajax_url, data, function(data_json) {

          'use strict';

          window.DALT.utility.refresh_cell_properties_highlight();

        });

        //set ajax in asynchronous mode
        jQuery.ajaxSetup({async: true});

      }

    },

    /*
     * Update the number of columns on the handsontable and on the "data" db table
     */
    update_columns: function() {

      'use strict';

      /**
       * Reset the spreadsheet clipboard because after performing this method certain references to cell properties
       * might be lost.
       */
      window.DALT.states.synthetic_clipboard = null;

      const current_number_of_columns = window.DALT.states.dalt_hot.countCols();
      if ($('#columns').val() < 1) {$('#columns').val(1);}
      let new_number_of_columns = parseInt($('#columns').val(), 10);

      //Do not allow to enter more columns than 40 columns
      if (new_number_of_columns > 40) {
        new_number_of_columns = 40;
        $('#columns').val(40);
      }

      if (new_number_of_columns > current_number_of_columns) {

        //set the new maximum number of columns
        window.DALT.states.dalt_hot.updateSettings({
          maxCols: new_number_of_columns,
        });

        //add the new columns
        let cells_to_add = [];
        const column_difference = new_number_of_columns - current_number_of_columns;
        const count_rows_result = window.DALT.states.dalt_hot.countRows();
        const count_cols_result = window.DALT.states.dalt_hot.countCols();

        for (let i = 1; i <= column_difference; i++) {

          for (let t = 1; t <= count_rows_result; t++) {

            if (t == 1) {
              //in row 1 add the default label text
              cells_to_add.push([0, (count_cols_result + i - 1), 'Label ' + parseInt(count_cols_result + i, 10)]);
            } else {
              //from row 2 initialize with 0 all the cells of the new column
              cells_to_add.push([(t - 1), (count_cols_result + i - 1), 0]);
            }

          }

        }

        //create the new columns
        window.DALT.states.dalt_hot.alter('insert_col', null, column_difference);

        //use the setDataAtCell() method one single time with a two dimensional array to avoid performance issues
        window.DALT.states.dalt_hot.setDataAtCell(cells_to_add);

      } else if (new_number_of_columns < current_number_of_columns) {

        const column_difference = current_number_of_columns - new_number_of_columns;

        window.DALT.states.dalt_hot.alter('remove_col', null, column_difference);

        //set the new maximum number of columns
        window.DALT.states.dalt_hot.updateSettings({
          maxCols: new_number_of_columns,
        });

      }

      //create or remove the new columns in the 'data' db table with an asynchronous ajax request --------------------
      if (new_number_of_columns != current_number_of_columns) {

        const data = {
          'action': 'dalt_add_remove_columns',
          'security': DALT_PARAMETERS.nonce,
          'table_id': window.DALT.utility.get_table_id(),
          'new_number_of_columns': new_number_of_columns,
        };

        //set ajax in synchronous mode
        jQuery.ajaxSetup({async: false});

        //send ajax request
        $.post(DALT_PARAMETERS.ajax_url, data, function(data_json) {

          'use strict';

          window.DALT.utility.refresh_cell_properties_highlight();

        });

        //set ajax in asynchronous mode
        jQuery.ajaxSetup({async: true});

      }

    },

    /*
     * Retrieves and displays the properties of the cell.
     *
     * If there are no properties associated with a cell the default values will be displayed.
     *
     * @param row Int The row of the cell
     * @param column Int The column of the cell
     */
    retrieve_cell_properties: function(row, column) {

      'use strict';

      const table_id = window.DALT.utility.get_table_id();
      let data_obj = null;
      let cell_properties_exists = null;

      //prepare ajax request
      const data = {
        'action': 'dalt_retrieve_cell_properties',
        'security': DALT_PARAMETERS.nonce,
        'table_id': table_id,
        'row': row,
        'column': column,
      };

      //send ajax request
      $.post(DALT_PARAMETERS.ajax_url, data, function(data_json) {

        'use strict';

        try {

          data_obj = JSON.parse(data_json);

          cell_properties_exists = true;

        } catch (e) {

          //set the default cell properties
          data_obj = {
            'table_id': table_id,
            'row_index': row,
            'column_index': column,
            'html_content': '',
            'text_color': '',
            'background_color': '',
            'font_weight': '400',
            'font_style': 'normal',
            'link': '',
            'link_color': '',
            'open_link_new_tab': '0',
            'image_left': '',
            'image_left_link': '',
            'image_left_open_link_new_tab': '0',
            'image_right': '',
            'image_right_link': '',
            'image_right_open_link_new_tab': '0',
            'alignment': 'center',
            'formula': 'sum',
            'formula_data': '',
            'row_slots': '1',
            'column_slots': '1',
          };

          cell_properties_exists = false;

        }

        //update the cell properties in the sidebar
        window.DALT.utility.update_cell_properties_in_sidebar(data_obj, cell_properties_exists);

      });

    },

    /*
     * Update or reset the cell properties of a cell in the "cell" db table
     */
    update_reset_cell_properties: function(task) {

      'use strict';

      /**
       * Reset the spreadsheet clipboard because after performing this method certain references to cell properties
       * might be lost.
       */
      window.DALT.states.synthetic_clipboard = null;

      const table_id = window.DALT.utility.get_table_id();
      const row_index = $('#cell-property-row-index').val();
      const column_index = $('#cell-property-column-index').val();
      const html_content = $('#cell-property-html-content').val();
      const text_color = $('#cell-property-text-color').val();
      const background_color = $('#cell-property-background-color').val();
      const font_weight = $('#cell-property-font-weight').val();
      const font_style = $('#cell-property-font-style').val();
      const link = $('#cell-property-link').val();
      const link_color = $('#cell-property-link-color').val();
      const open_link_new_tab = $('#cell-property-open-link-new-tab').val();
      const image_left = $('#cell-property-image-left').val();
      const image_left_link = $('#cell-property-image-left-link').val();
      const image_left_open_link_new_tab = $('#cell-property-image-left-open-link-new-tab').val();
      const image_right = $('#cell-property-image-right').val();
      const image_right_link = $('#cell-property-image-right-link').val();
      const image_right_open_link_new_tab = $('#cell-property-image-right-open-link-new-tab').val();
      const alignment = $('#cell-property-alignment').val();
      const formula = $('#cell-property-formula').val();
      const formula_data = $('#cell-property-formula-data').val();
      const row_slots = $('#cell-property-row-slots').val();
      const column_slots = $('#cell-property-column-slots').val();

      //prepare ajax request
      const data = {
        'action': 'dalt_update_reset_cell_properties',
        'security': DALT_PARAMETERS.nonce,
        'task': task,
        'table_id': table_id,
        'row_index': row_index,
        'column_index': column_index,
        'html_content': html_content,
        'text_color': text_color,
        'background_color': background_color,
        'font_weight': font_weight,
        'font_style': font_style,
        'link': link,
        'link_color': link_color,
        'open_link_new_tab': open_link_new_tab,
        'image_left': image_left,
        'image_left_link': image_left_link,
        'image_left_open_link_new_tab': image_left_open_link_new_tab,
        'image_right': image_right,
        'image_right_link': image_right_link,
        'image_right_open_link_new_tab': image_right_open_link_new_tab,
        'alignment': alignment,
        'formula': formula,
        'formula_data': formula_data,
        'row_slots': row_slots,
        'column_slots': column_slots,
      };

      switch (task) {

        case 'update-cell-properties':

          //update cell properties -----------------------------------------------------------------------------------
          if (window.DALT.utility.cell_properties_is_valid(data)) {

            //set ajax in synchronous mode
            jQuery.ajaxSetup({async: false});

            //send ajax request
            $.post(DALT_PARAMETERS.ajax_url, data, function(response) {

              'use strict';

              if (response.trim() == 'success') {

                //show success message
                if ($('#update-cell-properties').attr('data-action') == 'update') {
                  $('#cell-properties-added-updated-message p').text(objectL10n.cell_properties_updated_message);
                } else {
                  $('#cell-properties-added-updated-message p').text(objectL10n.cell_properties_added_message);
                }

                //hide error message
                $('#cell-properties-error-message').hide();

                $('#cell-properties-added-updated-message').show();
                clearTimeout(window.DALT.states.cell_properties_message_timeout_handler);
                window.DALT.states.cell_properties_message_timeout_handler = setTimeout(
                    function() {

                      'use strict';

                      $('#cell-properties-added-updated-message').hide();

                      }, 3000);

                //show the proper button with the proper text
                $('#update-cell-properties').attr('data-action', 'update');
                $('#update-cell-properties').val(objectL10n.update_cell_properties);
                $('#reset-cell-properties').show();

                //Highlight the cell properties
                window.DALT.utility.refresh_cell_properties_highlight();

              }

            });

            //set ajax in asynchronous mode
            jQuery.ajaxSetup({async: true});

          }

          break;

        case 'reset-cell-properties':

          //reset cell properties ------------------------------------------------------------------------------------
          $.post(DALT_PARAMETERS.ajax_url, data, function(response) {

            'use strict';

            if (response.trim() == 'success') {

              //set the default cell properties
              const data_obj = {
                'table_id': table_id,
                'row_index': row_index,
                'column_index': column_index,
                'html_content': '',
                'text_color': '',
                'background_color': '',
                'font_weight': '400',
                'font_style': 'normal',
                'link': '',
                'link_color': '',
                'open_link_new_tab': '0',
                'image_left': '',
                'image_left_link': '',
                'image_left_open_link_new_tab': '0',
                'image_right': '',
                'image_right_link': '',
                'image_right_open_link_new_tab': '0',
                'alignment': 'center',
                'formula': 'sum',
                'formula_data': '',
                'row_slots': '1',
                'column_slots': '1',
              };

              //update the cell properties in the sidebar
              window.DALT.utility.update_cell_properties_in_sidebar(data_obj, false);

              //hide error message
              $('#cell-properties-error-message').hide();

              //show success message
              $('#cell-properties-added-updated-message p').text(objectL10n.cell_properties_reset_message);
              $('#cell-properties-added-updated-message').show();
              clearTimeout(window.DALT.states.cell_properties_message_timeout_handler);
              window.DALT.states.cell_properties_message_timeout_handler = setTimeout(
                  function() {

                    'use strict';

                    $('#cell-properties-added-updated-message').hide();

                    }, 3000);

              //Highlight the cell properties
              window.DALT.utility.refresh_cell_properties_highlight();

            }

          });

          break;

      }

    },

    cell_properties_is_valid: function(data) {

      'use strict';

      //init variables
      let fields_with_errors_a = [];

      //define patterns ----------------------------------------------------------------------------------------------
      const hex_rgb_regex = /^#(?:[0-9a-fA-F]{3}){1,2}$/;
      const url_regex = /^https?:\/\/.+$/;
      const list_of_comma_separated_numbers = /^(\s*(\d+\s*,\s*)+\d+\s*|\s*\d+\s*)$/;

      //validate data ------------------------------------------------------------------------------------------------
      if (!data.text_color.match(hex_rgb_regex) && data.text_color.trim().length > 0) {
        fields_with_errors_a.push(objectL10n.text_color);
      }
      if (!data.background_color.match(hex_rgb_regex) && data.background_color.trim().length >
          0) {fields_with_errors_a.push(objectL10n.background_color);}
      if ((!data.link.match(url_regex) && data.link.trim().length > 0) || data.link.trim().length >
          2083) {fields_with_errors_a.push(objectL10n.link);}
      if (!data.link_color.match(hex_rgb_regex) && data.link_color.trim().length > 0) {
        fields_with_errors_a.push(objectL10n.link_color);
      }
      if ((!data.image_left.match(url_regex) && data.image_left.trim().length > 0) || data.image_left.trim().length >
          2083) {fields_with_errors_a.push(objectL10n.image_left);}
      if ((!data.image_left_link.match(url_regex) && data.image_left_link.trim().length > 0) ||
          data.image_left_link.trim().length > 2083) {fields_with_errors_a.push(objectL10n.image_left_link);}
      if ((!data.image_right.match(url_regex) && data.image_right.trim().length > 0) || data.image_right.trim().length >
          2083) {fields_with_errors_a.push(objectL10n.image_right);}
      if ((!data.image_right_link.match(url_regex) && data.image_right_link.trim().length > 0) ||
          data.image_right_link.trim().length > 2083) {fields_with_errors_a.push(objectL10n.image_right_link);}
      if (data.html_content.trim().length > 65535) {fields_with_errors_a.push(objectL10n.html_content);}
      if ((!data.formula_data.match(list_of_comma_separated_numbers) && data.formula_data.trim().length > 0) ||
          data.formula_data.trim().length > 110) {fields_with_errors_a.push(objectL10n.formula_data);}
      if (parseInt(data.row_slots, 10) < 0 || parseInt(data.row_slots, 10) > 65534) {
        fields_with_errors_a.push(objectL10n.row_slots);
      }
      if (parseInt(data.column_slots, 10) < 0 || parseInt(data.column_slots, 10) > 1000) {
        fields_with_errors_a.push(objectL10n.column_slots);
      }

      if (fields_with_errors_a.length > 0) {

        //hide the added/updated message if it's shown
        $('#cell-properties-added-updated-message').hide();

        //show error message
        $('#cell-properties-error-message p').
            html(objectL10n.cell_properties_error_partial_message + ' <strong>' + fields_with_errors_a.join(', ') +
                '</strong>');
        $('#cell-properties-error-message').show();

        return false;

      } else {

        //hide the error message if it's shown
        $('#cell-properties-error-message').hide();

        return true;

      }

    },

    /*
     Initializes Chosen on all the select elements
     */
    initialize_chosen: function() {

      'use strict';

      let chosen_elements = [];
      chosen_elements.push('#show-position');
      chosen_elements.push('#position-side');
      chosen_elements.push('#number-format');
      chosen_elements.push('#cell-property-font-weight');
      chosen_elements.push('#cell-property-font-style');
      chosen_elements.push('#cell-property-open-link-new-tab');
      chosen_elements.push('#cell-property-image-left-open-link-new-tab');
      chosen_elements.push('#cell-property-image-right-open-link-new-tab');
      chosen_elements.push('#cell-property-alignment');
      chosen_elements.push('#cell-property-formula');
      chosen_elements.push('#order-by-1');
      chosen_elements.push('#order-desc-asc-1');
      chosen_elements.push('#order-by-2');
      chosen_elements.push('#order-desc-asc-2');
      chosen_elements.push('#order-by-3');
      chosen_elements.push('#order-desc-asc-3');
      chosen_elements.push('#order-by-4');
      chosen_elements.push('#order-desc-asc-4');
      chosen_elements.push('#order-by-5');
      chosen_elements.push('#order-desc-asc-5');
      chosen_elements.push('#table-layout'),
          chosen_elements.push('#table-width');
      chosen_elements.push('#column-width');
      chosen_elements.push('#enable-container');
      chosen_elements.push('#enable-sorting');
      chosen_elements.push('#enable-manual-sorting');
      chosen_elements.push('#show-header');
      chosen_elements.push('#sticky-header');
      chosen_elements.push('#header-font-weight');
      chosen_elements.push('#header-font-style');
      chosen_elements.push('#header-position-alignment');
      chosen_elements.push('#body-font-weight');
      chosen_elements.push('#body-font-style');
      chosen_elements.push('#caption-show-caption');
      chosen_elements.push('#caption-caption-side');
      chosen_elements.push('#caption-text-align');
      chosen_elements.push('#caption-font-weight');
      chosen_elements.push('#caption-font-style');
      chosen_elements.push('#autocolors-priority');
      chosen_elements.push('#autoalignment-priority');
      chosen_elements.push('#order-data-type-1');
      chosen_elements.push('#order-data-type-2');
      chosen_elements.push('#order-data-type-3');
      chosen_elements.push('#order-data-type-4');
      chosen_elements.push('#order-data-type-5');
      chosen_elements.push('#order-date-format-1');
      chosen_elements.push('#order-date-format-2');
      chosen_elements.push('#order-date-format-3');
      chosen_elements.push('#order-date-format-4');
      chosen_elements.push('#order-date-format-5');
      chosen_elements.push('#phone-hide-images');
      chosen_elements.push('#tablet-hide-images');
      chosen_elements.push('#enable-cell-properties');
      chosen_elements.push('#formula-average-round');

      jQuery(chosen_elements.join(',')).chosen();

    },

    /*
     * Update the cell properties displayed in the sidebar based on the cell properties provided in the data_obj
     *
     * @param data_obj Object The object that includes the data properties
     * @param cell_properties_exists Bool A flag which indicates if the cell properties of this cell exists (the cell
     * properties comes from the 'cell' db table) or don't exist (the cell properties have been generated from the
     * default values)
     */
    update_cell_properties_in_sidebar: function(data_obj, cell_properties_exists) {

      'use strict';

      //Count the number of enabled cell properties
      let one_cell_property_exists = false;
      $('table.daext-form-cell-properties tr').each(function() {

        'use strict';

        if ($(this).css('display') !== 'none') {
          one_cell_property_exists = true;
        }

      });

      //Display the sidebar container if at least on cell property exists
      if (one_cell_property_exists) {

        //Show the sidebar container
        $('#sidebar-container').show();

        //Remove the bottom border on the cells of the last row of the cell properties table
        $('table.daext-form-cell-properties tr > *').css('border-bottom-width', '1px');
        $('table.daext-form-cell-properties tr:visible:last > *').css('border-bottom-width', '0');

      }

      //Set the title of the cell properties section
      if (data_obj.row_index == 0) {
        $('#cell-properties-title').text('Header ' + (parseInt(data_obj.column_index, 10) + 1));
      } else {
        $('#cell-properties-title').
            text('Body ' + parseInt(data_obj.row_index, 10) + ':' + (parseInt(data_obj.column_index, 10) + 1));
      }

      //Initialize the hidden fields used to store the row and column indexes
      $('#cell-property-row-index').val(data_obj.row_index);
      $('#cell-property-column-index').val(data_obj.column_index);

      /*
       * Text Color
       *
       * Since the iris color picker doesn't support an empty value, if the text_color value is empty delete the
       * color picker and create a new one
       */
      if (data_obj.text_color.length == 0) {

        //delete form the DOM the input field with all the elements created by the iris color picker
        $('#cell-property-text-color-container td .wp-picker-container').remove();

        //create the input element in the right position
        $('#cell-property-text-color-container td').
            prepend('<input value="" class="wp-color-picker" maxlength="7" type="text" id="cell-property-text-color">');

        //initialize the iris color picker
        $('#cell-property-text-color-container td .wp-color-picker').wpColorPicker();

      } else {
        $('#cell-property-text-color').iris('color', data_obj.text_color);
      }

      /*
       * Background Color
       *
       * Since the iris color picker doesn't support an empty value, if the background_color value is empty delete
       * the color picker and create a new one
       */
      if (data_obj.background_color.length == 0) {

        //delete form the DOM the input field with all the elements created by the iris color picker
        $('#cell-property-background-color-container td .wp-picker-container').remove();

        //create the input element in the right position
        $('#cell-property-background-color-container td').
            prepend(
                '<input value="" class="wp-color-picker" maxlength="7" type="text" id="cell-property-background-color">');

        //initialize the iris color picker
        $('#cell-property-background-color-container td .wp-color-picker').wpColorPicker();

      } else {
        $('#cell-property-background-color').iris('color', data_obj.background_color);
      }

      //Alignment
      $('#cell-property-alignment').val(data_obj.alignment).trigger('chosen:updated');

      //Font Weight
      $('#cell-property-font-weight').val(data_obj.font_weight).trigger('chosen:updated');

      //Font Style
      $('#cell-property-font-style').val(data_obj.font_style).trigger('chosen:updated');

      //Link
      $('#cell-property-link').val(data_obj.link);

      /*
       * Link Color
       *
       * Since the iris color picker doesn't support an empty value, if the link_color value is empty delete
       * the color picker and create a new one
       */
      if (data_obj.link_color.length == 0) {

        //delete form the DOM the input field with all the elements created by the iris color picker
        $('#cell-property-link-color-container td .wp-picker-container').remove();

        //create the input element in the right position
        $('#cell-property-link-color-container td').
            prepend('<input value="" class="wp-color-picker" maxlength="7" type="text" id="cell-property-link-color">');

        //initialize the iris color picker
        $('#cell-property-link-color-container td .wp-color-picker').wpColorPicker();

      } else {
        $('#cell-property-link-color').iris('color', data_obj.link_color);
      }

      //Open Link New Tab
      $('#cell-property-open-link-new-tab').val(data_obj.open_link_new_tab).trigger('chosen:updated');

      //Image Left
      $('#cell-property-image-left').val(data_obj.image_left);
      if (data_obj.image_left.length > 0) {
        $('#cell-property-image-left').prev().find('img').attr('src', data_obj.image_left).show();
        $('#cell-property-image-left').next().text($('#cell-property-image-left').next().attr('data-remove'));
        $('#cell-property-image-left').next().attr('data-set-remove', 'remove');
        $('#cell-property-image-left').next().next().hide();
      } else {
        $('#cell-property-image-left').prev().find('img').attr('src', '').hide();
        $('#cell-property-image-left').next().text($('#cell-property-image-left').next().attr('data-set'));
        $('#cell-property-image-left').next().attr('data-set-remove', 'set');
        $('#cell-property-image-left').next().next().show();
      }

      //Image Left Link
      $('#cell-property-image-left-link').val(data_obj.image_left_link);

      //Image Left Open Link New Tab
      $('#cell-property-image-left-open-link-new-tab').
          val(data_obj.image_left_open_link_new_tab).
          trigger('chosen:updated');

      //Image Right
      $('#cell-property-image-right').val(data_obj.image_right);
      if (data_obj.image_right.length > 0) {
        $('#cell-property-image-right').prev().find('img').attr('src', data_obj.image_right).show();
        $('#cell-property-image-right').next().text($('#cell-property-image-right').next().attr('data-remove'));
        $('#cell-property-image-right').next().attr('data-set-remove', 'remove');
        $('#cell-property-image-right').next().next().hide();
      } else {
        $('#cell-property-image-right').prev().find('img').attr('src', '').hide();
        $('#cell-property-image-right').next().text($('#cell-property-image-right').next().attr('data-set'));
        $('#cell-property-image-right').next().attr('data-set-remove', 'set');
        $('#cell-property-image-right').next().next().show();
      }

      //Image Right Link
      $('#cell-property-image-right-link').val(data_obj.image_right_link);

      //Image Right Open Link New Tab
      $('#cell-property-image-right-open-link-new-tab').
          val(data_obj.image_right_open_link_new_tab).
          trigger('chosen:updated');

      //Formula
      $('#cell-property-formula').val(data_obj.formula).trigger('chosen:updated');

      //Formula Data
      $('#cell-property-formula-data').val(data_obj.formula_data);

      //HTML Content
      $('#cell-property-html-content').val(data_obj.html_content);

      //Show the proper button with the proper text
      if (cell_properties_exists) {
        $('#update-cell-properties').attr('data-action', 'update');
        $('#update-cell-properties').val(objectL10n.update_cell_properties);
        $('#reset-cell-properties').show();
      } else {
        $('#update-cell-properties').attr('data-action', 'add');
        $('#update-cell-properties').val(objectL10n.add_cell_properties);
        $('#reset-cell-properties').hide();
      }

      //Row Slots
      $('#cell-property-row-slots').val(data_obj.row_slots);

      //Column Slots
      $('#cell-property-column-slots').val(data_obj.column_slots);

    },

    /*
     * Update the selection of a specific chosen field (field_selector) based on the provided value (selected_value)
     */
    update_chosen_field: function(field_selector, selected_value) {

      'use strict';

      $(field_selector + ' option').removeAttr('selected');
      $(field_selector + ' option[value=' + selected_value + ']').attr('selected', 'selected');
      $(field_selector).trigger('chosen:updated');

    },

    /*
     * Update the options available in the '#order-by-*' fields based on the number of columns defined in the #columns
     * field. The current selected option will be maintained if the selected column still exists.
     */
    update_order_by: function() {

      'use strict';

      const number_of_columns = parseInt($('#columns').val(), 10);

      for (let i = 1; i <= 5; i++) {

        //get the current value of the select element
        const current_value = $('#order-by-' + i).val();

        //delete the option elements
        $('#order-by-' + i + ' option').remove();

        //add the option elements based on the current number of columns
        let option_elements = '';
        for (let t = 1; t <= number_of_columns; t++) {
          option_elements += '<option value="' + t + '">' + objectL10n.column + ' ' + t + '</option>';
        }
        $('#order-by-' + i).append(option_elements);

        //apply the stored current value if the column still exists, otherwise select the first element
        if (current_value <= number_of_columns) {
          $('#order-by-' + i).val(current_value);
        } else {
          $('#order-by-' + i).val(1);
        }

        //update chosen
        $('#order-by-' + i).trigger('chosen:updated');

      }

    },

    /*
     * Moves the cell properties section on the bottom of the table section when the screen width goes below a specific
     * value.
     */
    responsive_sidebar_container: function() {

      'use strict';

      if ($('#wpcontent').width() < 1560) {

        $('#sidebar-container').addClass('sidebar-container-below-breakpoint');

      } else {

        $('#sidebar-container').removeClass('sidebar-container-below-breakpoint');

      }

    },

    /**
     * Verify the maximum number of cell properties involved in the context menu task. If the number of cell is smaller
     * or equal to 100 return true, otherwise generate an alert message and return false.
     *
     * @param options An object with included data about the selection performed on the Handsontable table.
     * @return bool
     */
    valid_cell_number: function(options) {

      'use strict';

      const number_of_rows = options.end.row - options.start.row + 1;
      const number_of_column = options.end.col - options.start.col + 1;
      if (number_of_rows * number_of_column <= 100) {
        return true;
      } else {
        $('.dialog-alert[data-id="valid-cell-number"]').dialog('open');
        return false;
      }

    },

    /**
     * The "has-cell-properties" class (used to highlight the cells with a specific background color) is added where the
     * cell properties exist.
     *
     * The following operations are performed:
     *
     * 1 - A list with the indexes of the cell properties is retrieved with an ajax request
     * 2 - The cell meta are removed from all the cell
     * 3 - The "has-cell-properties" class is added with to the cell meta
     *
     */
    refresh_cell_properties_highlight: function() {

      'use strict';

      //prepare ajax request
      const data = {
        'action': 'dalt_get_cell_properties_index',
        'security': DALT_PARAMETERS.nonce,
        'table_id': window.DALT.utility.get_table_id(),
      };

      //send ajax request
      $.post(DALT_PARAMETERS.ajax_url, data, function(data_json) {

        'use strict';

        try {

          const data_a = JSON.parse(data_json);

          //Remove the 'has-cell-properties' class from all the cells
          const number_of_rows = window.DALT.states.dalt_hot.countRows();
          const number_of_columns = window.DALT.states.dalt_hot.countCols();
          for (let i = 0; i < number_of_rows; i++) {
            for (let t = 0; t < number_of_columns; t++) {
              window.DALT.states.dalt_hot.setCellMeta(i, t, 'className', '');
            }
          }

          //Add the 'has-cell-properties' class to the celle where there are cell properties
          if (data_a.length > 0) {
            $.each(data_a, function(index, value) {

              'use strict';

              window.DALT.states.dalt_hot.setCellMeta(value['row_index'], value['column_index'], 'className',
                  'has-cell-properties');
            });
          }

          window.DALT.states.dalt_hot.render();

        } catch (e) {

          //do nothing

        }

      });

    },

    /**
     * Add the cell properties of the selected cells in the state used to store
     * the copied cell properties.
     */
    add_cell_properties_to_state: function(options, source){

      'use strict';

      //get the table id
      const table_id = window.DALT.utility.get_table_id();

      //prepare ajax request
      const data = {
        'action': 'dalt_retrieve_cell_properties_multiple',
        'security': DALT_PARAMETERS.nonce,
        'table_id': table_id,
        'row_start': options.start['row'],
        'column_start': options.start['col'],
        'row_end': options.end['row'],
        'column_end': options.end['col']
      };

      //send ajax request
      $.post(DALT_PARAMETERS.ajax_url, data, function(data_json) {

        'use strict';

        try {

          //Save the cell properties in the copied cell properties state.
          window.DALT.states.copiedCellProperties.data = JSON.parse(data_json);
          window.DALT.states.copiedCellProperties.source = source;

          //If this task has been generated from a "Cut Cell Properties"
          //operation remove the cell properties from the selected cells.
          if(source === 'cut'){
            window.DALT.utility.reset_cell_properties(options);
          }

        } catch (e) {

          //Invalid JSON data

        }

      });

    },

    /**
     * Reset the cell properties of the selected cells.
     *
     * @param options
     */
    reset_cell_properties: function(options){

      'use strict';

      /**
       * Reset the spreadsheet clipboard because after performing this method certain references to cell properties
       * might be lost.
       */
      window.DALT.states.synthetic_clipboard = null;

      //prepare ajax request
      const data = {
        'action': 'dalt_reset_cell_properties',
        'security': DALT_PARAMETERS.nonce,
        'table_id': window.DALT.utility.get_table_id(),
        'options': JSON.stringify(options),
      };

      //set ajax in synchronous mode
      jQuery.ajaxSetup({async: false});

      //send ajax request
      $.post(DALT_PARAMETERS.ajax_url, data, function() {

        'use strict';

        window.DALT.utility.refresh_cell_properties_highlight();

      });

      //set ajax in asynchronous mode
      jQuery.ajaxSetup({async: true});

    }

  };

}(window.jQuery));